;
; Major BBS Chat Emulation Control File
;
; This file is designed to provide emulation of Major BBS chat functionality.
; It does not necessarily provide all the features of Major's chat, but it
; does provide all the common functionality in as close a presentation as
; possible.
;
; Please note that this is patterned after Major's "Entertainment Edition"
; chat, not the chat included with the standard package.
;
; This control file requires a /E:2 entry style in the Opt Data
; of UltraChat when you invoke this control file.
;
; ----- HEADER ------------------------------------------------------
;
; ** CHANGE FOR YOUR OWN NEEDS **
;
SYSTEM_NAME_TEXT "Test Ultra-Chat System"
SYSTEM_ID_TEXT "UltraTst"
SYSOP_NAME_TEXT "The SysOp"
UCHAT_DIR SLASHT
;
; This includes a moan macro file
;
INCLUDE MOANS.INC
;
; ----- STYLE AND GENERAL -------------------------------------------
;
LIST_ME_SWITCH FALSE
KILL_LINE_KEY ^^
ENTER_STRING "^^"
MIN_CHANNEL_NUM 0
IS_TEXT "is"
ARE_TEXT "are"
IGNORED_TEXT "*"
INVITED_TEXT "*"
;
; ----- MAJOR BBS STYLE COMMANDS IN ALPHA ORDER ---------------------
;
; Get list of moan macros
;
HELP#02_CMD     "ACTION LIST" MODE=ACDEFG        ;ACTION LIST
HELP#02_CMD     "/A LIST"     MODE=ABCDEFG EXACT ;/A LIST
   HELP#02_FILE  MOANS.LST
   HELP#02_ERROR "^[[1;35mAction list file not found!^M"
;
; Display moan help
;
HELP#03_CMD     "ACTION ?"    MODE=ACDEFG  EXACT ;ACTION ?
HELP#03_CMD     "/A ?"        MODE=ABCDEFG EXACT ;/A ?
   HELP#03_FILE  MOANS.HLP
   HELP#03_ERROR "^[[1;35mAction help file not found!^M"
;
; Enable moan macro use
;
ON#05_CMD       "ACTION ON"   MODE=ACDEFG  EXACT ;ACTION ON
ON#05_CMD       "/A ON"       MODE=ABCDEFG EXACT ;/A ON
   ON#05_TEXT "^[[1;32m...Ok, you're in action mode now!! (type '^[[36maction ?^[[32m' for help).^M"
;
; Disable moan macro use
;
OFF#05_CMD      "ACTION OFF"  MODE=ACDEFG  EXACT ;/A OFF
OFF#05_CMD      "/A OFF"      MODE=ABCDEFG EXACT ;/A OFF
   OFF#05_TEXT "^[[1;32m...Back to regular teleconference mode...^M"
;
; Go to another user's private channel
;
CHANNEL#02_CMD  JOIN          MODE=CDFG    EXACT ;JOIN
CHANNEL#02_CMD  /J            MODE=BCDFG   EXACT ;/J
   CHANNEL#02_CHANPMT "^[[1;32mWho's private channel would you like to join? "
   CHANNEL#02_NOTINV  "^[[1;35mSorry, but you're not invited to %RUSER:C%'s private channel!^M"
   CHANNEL#02_ENTRY   "%RUSER:C% has just arrived from another channel.^M"
   CHANNEL#02_EXIT    "%RUSER:C% has just gone to another channel.^M"
;
; Go to another user's private channel
;
CHANNEL#03_CMD  JOIN          MODE=CDFG          ;JOIN <who>
CHANNEL#03_CMD  /J            MODE=BCDFG   BLANK ;/J <who>
   CHANNEL#03_CHANPMT =CHANNEL#02_CHANPMT
   CHANNEL#03_NOTINV  =CHANNEL#02_NOTINV
   CHANNEL#03_ENTRY   =CHANNEL#02_ENTRY
   CHANNEL#03_EXIT    =CHANNEL#02_EXIT
;
; Ignore another user
;
INTERACT#01_CMD FORGET        MODE=BCDEFG        ;FORGET
INTERACT#01_CMD /F            MODE=BCDEFG  EXACT ;/F
INTERACT#01_CMD /F            MODE=BCDEFG  BLANK ;/F
   INTERACT#01_ON     "^[[1;32mOkay, you will not receive any of %RUSER:C%'s whispers,
      +     | pages, chat requests, or invitations.  You will also not see
      +     | any of their public messages or actions and %RUSER:C% has been
      +     | uninvited from your private channel.  Enjoy the peace and quiet!^M"
   INTERACT#01_OFF    '^[[1;32mOkay, you have no longer "forgotten" about %RUSER:C% (i.e.
      +     | you will see all of their messages again).^M'
   INTERACT#01_ALLON  "^[[1;32mOkay, you have now forgotten ALL users.^M"
   INTERACT#01_ALLOFF "^[[1;32mOkay, you have remembered all users.^M"
;
; Unignore another user
;
INTERACT#02_CMD REMEMBER      MODE=BCDEFG        ;REMEMBER
INTERACT#02_CMD /R            MODE=BCDEFG  EXACT ;/R
INTERACT#02_CMD /R            MODE=BCDEFG  BLANK ;/R
   INTERACT#02_ON     =INTERACT#01_ON
   INTERACT#02_OFF    =INTERACT#01_OFF
   INTERACT#02_ALLON  =INTERACT#01_ALLON
   INTERACT#02_ALLOFF =INTERACT#01_ALLOFF
;
; Invite a user to your private channel
;
INTERACT#04_CMD "INVITE ALL"  MODE=BCDEFG  EXACT ;INVITE ALL
INTERACT#04_CMD INVITE        MODE=BCDEFG        ;INVITE <who>
INTERACT#04_CMD "/I ALL"      MODE=BCDEFG  EXACT ;/I ALL
INTERACT#04_CMD /I            MODE=BCDEFG  BLANK ;/I <who>
   INTERACT#04_ALLON '^[[1;32mOkay, now anyone and everyone can join your private channel.^M
      +      Enter "^[[36muninvite all^[[32m" to deactivate this mode.^M'
   INTERACT#04_ON "^[[1;32mOkay, %RUSER:C% is invited to your private channel.^M"
   INTERACT#04_ON2 "^[[1;32mOkay, %RUSER:C% is invited to your private channel.^M
      +       NOTE: You are not currently in your private channel.^M
      +       Your invitation only applies to YOUR private channel.^M"
   INTERACT#04_REMOTEINUC '%RUSER:C% has invited you to their private channel.^M
      +      Enter "^[[36mjoin %RUSER:C%^[[33m" to go there while in teleconferencing.^M'
   INTERACT#04_REMOTE "%RUSER:C% has invited you to their private channel.^M"
;
; Uninvite (kick out) a user from your private channel
;
INTERACT#05_CMD "UNINVITE ALL" MODE=BCDEFG EXACT ;UNINVITE ALL
INTERACT#05_CMD UNINVITE      MODE=BCDEFG        ;UNINVITE <who>
INTERACT#05_CMD "/U ALL"      MODE=BCDEFG  BLANK ;/U ALL
INTERACT#05_CMD /U            MODE=BCDEFG  BLANK ;/U <who>
   INTERACT#05_ALLOFF "^[[1;32mOkay, your private channel is no longer open for anyone to enter.^M
      +      To remove anyone currently in your private channel, specifically
      +     | uninvite them (i.e. ^[[36mUNINVITE <who>^[[32m).^M"
   INTERACT#05_OFF2 "^[[1;32mOkay, %RUSER:C% has been uninvited from your private channel.^M"
   INTERACT#05_OFF  "^[[1;32mOkay, %RUSER:C% has been uninvited and kicked out
      +     | from your private channel.^M"
   INTERACT#05_REMOVE "You have just been uninvited from %RUSER:C%'s private channel!^M
      +      Returning to the main channel.^M"
;
; Send a private message to a user
;
PRIVATE#01_CMD  "WHISPER TO"  MODE=ACDFG         ;WHISPER TO
   PRIVATE#01_REMOTE  "From %RUSER:C% (whispered): %RMSG%^M"
   PRIVATE#01_CONFIRM "^[[1;33m-- Message sent only to %RUSER:C% --^M"
   PRIVATE#01_NAMEPMT "^[[1;32mWhich User-ID?  ^[[1;36m"
   PRIVATE#01_MSGPMT  "^[[1;32mInput up to 2 lines of text to send to %RUSER:C%:^M^M^[[1;36m"
   PRIVATE#01_NOCHAT  "^[[1;35m^MSorry, but that user asked not to be disturbed!^M"
   PRIVATE#01_ERROR   "^[[1;35m^MThat user cannot be interrupted right now.^M"
;
; Page another user
;
PRIVATE#02_CMD  /P            MODE=ABCDEFG EXACT ;/P <who> ...
PRIVATE#02_CMD  /P            MODE=ABCDEFG BLANK ;/P <who> ...
PRIVATE#02_CMD  PAGE          MODE=ACDFG         ;PAGE <who> ...
   PRIVATE#02_REMOTE  "^G%RUSER:C% is paging you from Teleconference: %RMSG%^M"
   PRIVATE#02_EMPTY   "^G%RUSER:C% is paging you from Teleconference!^M"
   PRIVATE#02_CONFIRM "^[[1;32m... Paging %RUSER:C% ...^M"
   PRIVATE#02_NAMEPMT =PRIVATE#01_NAMEPMT
   PRIVATE#02_MSGPMT  =PRIVATE#01_MSGPMT
   PRIVATE#02_NOCHAT  =PRIVATE#01_NOCHAT
   PRIVATE#02_ERROR   =PRIVATE#01_ERROR
;
; Exit from chat
;
EXIT#02_CMD     /X            MODE=BE      EXACT ;/X
EXIT#02_CMD     X             MODE=BE      EXACT ;X
;
; Exit from chat
;
EXIT#01_CMD     /X            MODE=CDFG    EXACT ;/X
EXIT#01_CMD     X             MODE=CDFG    EXACT ;X
EXIT#01_CMD     EXIT          MODE=CDFG    EXACT ;EXIT
;
; Help file display
;
HELP#01_CMD     /?            MODE=ABCDEFG EXACT ;/?
HELP#01_CMD     ?             MODE=ACDFG   EXACT ;?
   HELP#01_FILE  MBBSHELP.TXT
   HELP#01_ERROR "^[[1;35mHelp file not found!^M"
;
; Alternate form of paging a user
;
CHAT#06_CMD     /C            MODE=ABCDEFG EXACT ;/C
CHAT#06_CMD     /C            MODE=ABCDEFG BLANK ;/C
CHAT#06_CMD     CHAT          MODE=ACDFG         ;CHAT
   CHAT#06_PROMPT "^[[1;32mWhich User-ID?  ^[[1;36m"
   CHAT#06_EXIT "%RUSER:C% has just left the teleconference.^M"
   CHAT#06_REMOTE '^G%RUSER:C% is requesting you join them in chat!^M
      +        Type "^[[36mC^[[33m" from the menu or "^[[36mchat %RUSER:C%^[[33m"
      +      | if already in chat to accept.^M'
   CHAT#06_CONFIRM "^[[1;33mOk, %RUSER:C% has been notified of your request to chat.^M"
   CHAT#06_NOCHAT "^[[1;35m^MSorry, but that user asked not to be disturbed!^M"
   CHAT#06_SELF "^[[1;35mSorry, but you can't do that to yourself!^M"
;
; Who display (people in chat)
;
WHO#01_CMD      /#            MODE=BCDEFG  EXACT ;/#
WHO#01_CMD      #             MODE=ACDFG   EXACT ;#
WHO#01_CMD      USERS         MODE=ACDFG   EXACT ;USERS
   WHO#01_HEADER "^[[1;32m^MLINE USER-ID                     ...... OPTION SELECTED^M"
   WHO#01_INVISIBLE "^[[1;33m %RLINE%  THIS USER IS CURRENTLY INVISIBLE^M"
   WHO#01_NORMAL "^[[1;33m %RLINE:2%  %RUSER:30C% ... %RCOMMAND%^M"
;
; Who display (all users)
;
WHO#08_CMD      SCAN          MODE=ACDFG   EXACT ;SCAN
WHO#08_CMD      /S            MODE=ABCDEFG EXACT ;/S
   WHO#08_HEADER "^[[1;32mUser-ID                       ... F I ... Channel (Topic)^M
      +              ---------------------------------------------------------^M"

   WHO#08_NORMAL "^[[1;32m%RUSER:30C%... %IGNORED:1% %INVITED:1% ... %RCHANNEL%^M"
;
; Three-line bio commands
;
BIO#02_CMD      /E            MODE=ABCDEFG EXACT ;/E
BIO#02_CMD      EDIT          MODE=ACDFG   EXACT ;EDIT
   BIO#01_PROMPT "Before you proceed, you MUST fill out the three line bio.  The
      +    | more interesting you make your bio, the more mail you will
      +    | receive!  You have 240 characters (approximately 3 lines) of
      +    | text to use.  Do not press <Enter> until you are done!  Word
      +    | wrapping happens automatically.  Start typing: ^M^M"

   BIO#02_PROMPT "You are about to change your three line bio.  The more 
      +    | interesting you make your bio, the more mail you will
      +    | receive!  You have 240 characters (approximately 3 lines)
      +    | of text to use.  Do not press <Enter> until you are done!
      +    |  Word wrapping happens automatically.  Start typing: ^M^M"

   BIO#02_YN "Are you sure you want to change your three line bio (Y/N)? "
;
; Toggle shortcut only mode
;
TOGGLE#04_CMD   /SHORTCUT     MODE=ACDEFG  EXACT ;/SHORTCUT
TOGGLE#04_CMD   SHORTCUT      MODE=ACDEFG  EXACT ;SHORTCUT
   TOGGLE#04_ON  "^[[1;32mYou are now in shortcut only mode.^M"
   TOGGLE#04_OFF "^[[1;32mYou are now in full command mode.^M"
;
; Generic action command
;
ACTION#01_CMD   GA            MODE=CDFG    BLANK ;GA
   ACTION#01_CONFIRM "^[[1;32m-- Generic action sent --^M"
   ACTION#01_REMOTE  "%RUSER:C% %RMSG%^M"
;
; Set topic for private channel
;
EDIT#02_CMD     TOPIC         MODE=ACDEFG        ;TOPIC
EDIT#02_CMD     /T            MODE=ABCDEFG EXACT ;/T
EDIT#02_CMD     /T            MODE=ABCDEFG BLANK ;/T
   EDIT#02_PROMPT  "^[[1;32mWhat is your topic? ^[[36m"
   EDIT#02_CONFIRM '^[[1;32mOkay, the topic for your private channel is "%TOPIC%".^M'
;
; Go back to main channel
;
EXIT#02_CMD     MAIN          MODE=CDEFG   EXACT ;/M
EXIT#02_CMD     /M            MODE=BCDEFG  EXACT ;/M
;
; Private message send alternate form
;
;NOTE: This one MUST be last so it doesn't match /cmd strings!!!
PRIVATE#01_CMD  /             MODE=ABCDEFG       ;/<name>
;
; Special command for when Enter is pressed
;
WHO#07_CMD      ^^            MODE=CDFG    EXACT ;command for just enter
   WHO#07_PRIVATE "^[[1;32mYou are in private chat with %RUSER:C% on line %RLINE%^M"
   WHO#07_HISCHAN "^[[1;32mYou're in %RUSER:C%'s private channel.^M"
   WHO#07_MYCHAN "^[[1;32mYou're in your private channel.^M"
   WHO#07_PUBLIC "^[[1;32mYou're in the main channel.^M"
   WHO#07_NORMAL "^[[1;37m%RUSER:C%^[[32m, "
   WHO#07_NOUSERS '^[[1;32mThere is currently no one else here with you.^M
         +              Just enter "?" if you need any assistance...^M'
   WHO#07_TOTAL '%IS/ARE% here with you.^MJust enter "?" if you need any assistance...^M'
;
; Users waiting display
;
CHAT#02_TEXT " %RLINE:2%  %RUSER:C%^M"
;
; User you're waiting on logged off
;
CHAT#24_TEXT "^[[1;32m^MThe user you are waiting for is no longer logged on, exiting wait mode.^M"
;
; Error messages
;
ERROR#01_TEXT "^[[1;35mUnrecognized command.  Type ? for Help.^M"
ERROR#02_TEXT "^[[1;35mThat user is not currently logged on.^M"
ERROR#03_TEXT "^[[1;35mThat user name refers to multiple users.  Please be more
      +     | specific with the name.^M"
ERROR#04_TEXT "^[[1;35m^MW commands are not allowed while you are invisible.^M"
ERROR#05_TEXT "^[[1;35m^MSorry, but that user asked not to be disturbed!^M"
ERROR#06_TEXT "^[[1;35mSorry, but you can't do that to yourself!^M"
ERROR#07_TEXT "^[[1;35mThat user name can refer to multiple users, if you wish to send
      +    | to a specific user, end the user name with a : for example 'SYSOP:' or
      +    | '%USER:C%:'^M"
;
; Users waiting to chat header
;
CHAT#03_TEXT "^[[1;32mThe following user(s) are waiting to chat with you:^M^M"
;
; Chat with user waiting prompt
;
CHAT#04_TEXT "^[[1;32mWould you like to go into private chat with this user (Y/n)? ^[[1;36m"
;
;
;
CHAT#05_TEXT "^[[1;32mEnter the line number of the person that you want to
      +            | chat with, or C to enter chat with someone else: ^[[1;36m"

CHAT#06_TEXT "^[[1;32mEnter the line number of the person that you want to
      +            | chat with, P for public chat with everyone, or X to exit: ^[[1;36m"

CHAT#07_TEXT "^[[1;32m^MDo you wish to wait for the other user (Y/n)? ^[[1;36m"

CHAT#08_TEXT "^[[1;32m^MYou are now waiting for the other user.  A period
      +              | will appear every 5 seconds while you wait.  Press
      +              | the <Enter> key at any time to stop waiting for the
      +              | other user.^M^M"

CHAT#09_TEXT "^[[1;33m^M^M...Okay, exiting chat...^M"

CHAT#10_TEXT '^[[1;33m^M^[[1;33m*** Chat Mode Activated ***^[[32m^M
      +      Type "^[[36mX^[[32m" on a blank line to exit.^M^M'

CHAT#12_TEXT "^[[1;36m"

CHAT#13_TEXT "^[[1;36m:"
CHAT#20_TEXT =CHAT#13_TEXT
CHAT#21_TEXT =CHAT#13_TEXT
CHAT#22_TEXT =CHAT#13_TEXT

CHAT#16_TEXT "^[[1;32m-- Message sent --^M"

CHAT#17_TEXT "^[[1;32m-- No one is here with you, message not sent --^M"

MISC#02_TEXT "^[[1;32mPress any key to continue..."

MISC#05_TEXT "^[[1;37m^L"

MISC#07_TEXT "^[[1;32mThe owner of this private channel has logged off.^M
      +       You are being placed in public chat.^M^M"

MISC#08_TEXT "^^^M^[[1;35m*** Message Aborted ***^M"

COLOR#01_TEXT "^[[1;36m"

COLOR#02_TEXT "^[[1;33m"

;
; The following strings are set up for what we believe is a "nicer"
; looking implementation than the default Major BBS emulation.  Given
; below this section is another section which can be used instead
; which gives TRUE Major BBS emulation.
;
CHAT#01_TEXT "From %RUSER:C%: %RMSG%^M"
CHAT#23_TEXT "^[[0;1;33m***^M"
CHAT#14_TEXT "%RUSER:C% just joined this channel!^M"
CHAT#19_TEXT "%RUSER:C% just vanished!^M"
MISC#09_TEXT "^[[0;1;37mWelcome to %VERSION% in Major BBS emulation mode!^M^M
      +      ^[[1;33mTeleconference Link-Up^M----------------------^M"
MISC#03_TEXT "%RUSER:C% just logged in.^M"
CHAT#15_TEXT "%RUSER:C% has just left the teleconference.^M"

;
; For TRUE Major BBS Entertainment Edition emulation, the following
; strings should be used to replace their counterparts above.
;
;PRIVATE#01_REMOTE "^[[1;33m***^MFrom %RUSER:C% (whispered): %RMSG%^M"
;CHAT#01_TEXT "^[[1;33m***^MFrom %RUSER:C%: %RMSG%^M"
;PRIVATE#02_REMOTE "^G^[[1;33m***^M%RUSER:C% is paging you from Teleconference: %RMSG%^M"
;ACTION#01_REMOTE "^[[1;33m***^M%RUSER:C% %RMSG%^M"
;PRIVATE#02_EMPTY "^G^[[1;33m***^M%RUSER:C% is paging you from Teleconference!^M"
;INTERACT#04_REMOTEINUC '^[[1;33m***^M%RUSER:C% has invited you to their private channel.^M
;      +      Enter "^[[36mjoin %RUSER:C%^[[33m" to go there while in teleconferencing.^M'
;INTERACT#04_REMOTE "^[[1;33m***^M%RUSER:C% has invited you to their private channel.^M"
;INTERACT#05_REMOVE "^[[1;33m***You have just been uninvited from %RUSER:C%'s private channel!^M
;      +      Returning to the main channel.^M"
;CHAT#14_TEXT "^[[1;33m***^M%RUSER:C% just joined this channel!^M"
;CHANNEL#02_ENTRY "^[[1;33m***^M%RUSER:C% has just arrived from another channel.^M"
;CHAT#01_EXIT "^[[1;33m***^M%RUSER:C% has just left the teleconference.^M"
;CHANNEL#02_EXIT "^[[1;33m***^M%RUSER:C% has just gone to another channel.^M"
;CHAT#19_TEXT "^[[1;33m***^M%RUSER:C% just vanished!^M"
;MISC#09_TEXT "^[[1;33mTeleconference Link-Up^M----------------------^M"
;CHAT#15_TEXT "^[[1;33m%RUSER:C% has just left the teleconference.^M"
;
; In real Major BBS, the following string does not exist.  Leave
; it commented out if you want to have emulation be more exact.
;
;MISC#03_TEXT "^[[1;33m***^M%RUSER:C% just logged in.^M"
